
; reads dimming voltage and provides a programmable output voltage
; AN3 for dimmer in
; PWM output at pin 5 for voltage out
; AN0 for programming output voltage
; program switch GP1


	ERRORLEVEL -302
	ERRORLEVEL -306

	    list      p=12F617        	; list directive to define processor
     #include <p12F617.inc>        ; processor specific variable definitions


   __CONFIG   _CP_OFF & _BOR_OFF & _MCLRE_ON & _WDT_OFF & _PWRTE_ON &_INTRC_OSC_NOCLKOUT & _IOSCFS_8MHZ &_WRT_OFF

; RAM 
; Bank 0
NEGATIVE			equ	H'20'	; subtraction negative flag
SHIFT				equ	H'21'	; shift storage
STORE1				equ	H'22'	; storage and for delay counter	
STORE2				equ	H'23'	; storage and delay counter
TEMP				equ	H'24'	; temporary
PROGRAM			equ	H'25'	; program voltage read from VR1  0-5V measured at TP2
VOLT_VAL			equ	H'26'	; programming/ input voltage value 1-15 ranges
A_D_LS				equ	H'27'	; A/D ls byte value from ADRESL
OUT0				equ	H'28'	; output ms byte
OUT1				equ	H'29'	; output ls byte
RAMP				equ	H'2A'	; output change rate
OUT0_RAMP		equ	H'2B'	; ramping value ms byte
OUT1_RAMP		equ	H'2C'	; ramping value ls byte
RAMP_COUNT		equ	H'2D'	; working value
COUNT				equ	H'2E'	; counter for ramping output

; DATA in the ms and ls bytes for 10-bit A/D value. Stored to program memory H0700 to H071F
IN1ms				equ	H'30'	; voltage input for point 1
IN1ls				equ	H'31'	; 
CURVE1ms			equ	H'32'	; voltage output at point 1
CURVE1ls			equ	H'33'	;
IN2ms				equ	H'34'	; voltage input for point 2
IN2ls				equ	H'35'	; 
CURVE2ms			equ	H'36'	; voltage output at point 2
CURVE2ls			equ	H'37'	;
; end 4-word block

IN3ms				equ	H'38'	; voltage input for point 3
IN3ls				equ	H'39'	; 
CURVE3ms			equ	H'3A'	; voltage output at point 3
CURVE3ls			equ	H'3B'	;
IN4ms				equ	H'3C'	; voltage input for point 4
IN4ls				equ	H'3D'	; 
CURVE4ms			equ	H'3E'	; voltage output at point 4
CURVE4ls			equ	H'3F'	;
; end 4-word block

IN5ms				equ	H'40'	; voltage input for point 5
IN5ls				equ	H'41'	; 
CURVE5ms			equ	H'42'	; voltage output at point 5
CURVE5ls			equ	H'43'	;
IN6ms				equ	H'44'	; voltage input for point 6
IN6ls				equ	H'45'	; 
CURVE6ms			equ	H'46'	; voltage output at point 6
CURVE6ls			equ	H'47'	;
; end 4-word block

IN7ms				equ	H'48'	; voltage input for point 7
IN7ls				equ	H'49'	; 
CURVE7ms			equ	H'4A'	; voltage output at point 7
CURVE7ls			equ	H'4B'	;
IN8ms				equ	H'4C'	; voltage input for point 8
IN8ls				equ	H'4D'	; 
CURVE8ms			equ	H'4E'	; voltage output at point 8
CURVE8ls			equ	H'4F'	;
; end 4-word block
; end 16 word

IN9ms				equ	H'50'	; voltage input for point 9
IN9ls				equ	H'51'	; 
CURVE9ms			equ	H'52'	; voltage output at point 9
CURVE9ls			equ	H'53'	;
IN10ms				equ	H'54'	; voltage input for point 10
IN10ls				equ	H'55'	; 
CURVE10ms			equ	H'56'	; voltage output at point 10
CURVE10ls			equ	H'57'	;
; end 4-word block

IN11ms				equ	H'58'	; voltage input for point 11
IN11ls				equ	H'59'	; 
CURVE11ms			equ	H'5A'	; voltage output at point 11
CURVE11ls			equ	H'5B'	;
IN12ms				equ	H'5C'	; voltage input for point 12
IN12ls				equ	H'5D'	; 
CURVE12ms			equ	H'5E'	; voltage output at point 12
CURVE12ls			equ	H'5F'	;
; end 4-word block

IN13ms				equ	H'60'	; voltage input for point 13
IN13ls				equ	H'61'	; 
CURVE13ms			equ	H'62'	; voltage output at point 13
CURVE13ls			equ	H'63'	;
IN14ms				equ	H'64'	; voltage input for point 14
IN14ls				equ	H'65'	; 
CURVE14ms			equ	H'66'	; voltage output at point 14
CURVE14ls			equ	H'67'	;
; end 4-word block

IN15ms				equ	H'68'	; voltage input for point 15
IN15ls				equ	H'69'	; 
CURVE15ms			equ	H'6A'	; voltage output at point 15
CURVE15ls			equ	H'6B'	;
IN16ms				equ	H'6C'	; voltage input for point 16
IN16ls				equ	H'6D'	; 
CURVE16ms			equ	H'6E'	; voltage output at point 16
CURVE16ls			equ	H'6F'	;
; end 4-word block
; 32 words for storage

; all banks RAM
; Flash read/ write registers
DATA_ADD			equ	H'70'	; Load initial data address when writing to memory
READADDMS		equ	H'71'	; flash memory read address ms byte making up a 14 bit byte (ms byte has 6 bits)
READADDLS		equ	H'72'  	; flash memory read address ls byte (ls byte has 8 bits)
TEMP_VAL			equ	H'73'	; ms byte of read 

; input/output band interpolation registers
BAND_SPAN0		equ	H'74'	; ms byte of input band span
BAND_SPAN1		equ	H'75'	; ls byte of input band span
OUT_SPAN0			equ	H'76'	; ms byte of output span
OUT_SPAN1			equ	H'77'	; ls byte of output span
IN_BAND0			equ	H'78'	; ms byte of bottom of band value
IN_BAND1			equ	H'79'	; ls byte of bottom of input band value	
OUT_BAND0			equ	H'7A'	; ms byte of bottom of output band value 	
OUT_BAND1			equ	H'7B'	; ls byte of bottom of output band value 	
		
; Bank 1 A0-BF

; initial values

	org	H'700'		; start address of where data memory is stored. Initially each at H3FFF so values ignored. Range when programmed are 0- D1023 (H3FF)
					; DW H'3FF', H'3FF'	
								
; ******************************************************************

; start at memory 0

	org		0				; reset vector
		
MAIN
;  set oscillator calibration
	bsf		STATUS,RP0     	; bank 1
        movlw   D'0'     			 ; set oscillator to factory calibrated frequency 
        movwf   OSCTUNE
	bcf		STATUS,RP0
SETUP
; set inputs/outputs
	movlw	B'00000000'
	movwf	GPIO			; ports low
	movlw	B'00000111'		; comparators off
	movwf	CMCON0
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000010'		; pullups off/on
	movwf	WPU
	movlw	B'00011011'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	movlw	B'00000000'		; settings (pullups) prescaler/2
	movwf	OPTION_REG
; analog inputs, A/D
	movlw	B'00101001'
	movwf	ANSEL			; digital I/O and analog at AN0 and AN3
	bcf		STATUS,RP0	; select memory bank 0
; bits 4-2
; 000 = Channel 00 (AN0)
; 011 = Channel 03 (AN3)
	movlw	B'10001100'		; channel 3, right justified, VDD ref etc
	movwf	ADCON0
	bsf		ADCON0,0		; A/D on

; pwm set
	bsf		STATUS,RP0	; select memory bank 1
	movlw	D'255'			; 
	movwf	PR2				; PWM period register. 
	bcf		STATUS,RP0	; memory bank 0
	movlw	D'00'			; zero for off 
	movwf	CCPR1L		; ls byte of PWM
	movlw	B'00000000'		; prescaler /1 for 7.812kHz
	movwf	T2CON
	bsf		T2CON,2		; enable timer 2
	movlw	B'00001100'		; set PWM mode bits 4 and 5 are ms bits of 10-bit PWM 
	movwf	CCP1CON		; enable PWM operation

	clrf		OUT0			; PWM output value ms byte
	clrf		OUT0_RAMP	; ramping value ms byte
	clrf		OUT1			; ls byte PWM value
	clrf		OUT1_RAMP	; ls byte ramping
	clrf		RAMP_COUNT	; working value for ramp rate

; start delay for S1 closure detect
	call		DELAY100		;  100ms	

; Start by a read of stored data

	movlw	H'30'
	movwf	FSR			; indirect pointer address

	movlw	H'07'			; ms address byte (H0700 start)
	movwf	READADDMS 
	movlw	H'00'
	movwf	READADDLS	; ls address byte
READ_LOOP
	call		READ			; 'w' has data
	movwf	TEMP
; ms byte
	movf	TEMP_VAL,w			
	movwf	INDF			; placed in RAM at FSR address
	incf		FSR,f
	movf	TEMP,w
	movwf	INDF
	incf		READADDLS,f	; next ls address byte
; stop when FSR=6F
	movf	FSR,w
	sublw	H'6E'
	btfss	STATUS,C		; when carry is clear then end of memory to read
	goto	END_READ
	incf		FSR,f
	goto	READ_LOOP
; values read
END_READ

; set ramp rate
; bits 4-2
; 000 = Channel 00 (AN0)
	movlw	B'10000000'		; channel 0, right justified, VDD ref etc
	movwf	ADCON0
	bsf		ADCON0,0		; A/D on
; delay	
	call		DELAY100		;  100ms	
	call		ACQUIRE_AD	; read input
; ADRESH has MS bits (Bits1,0), A_D_LS has ls byte

	movf	ADRESH,w
	movwf	TEMP			; get ADRESH into working register
; set for 8-bits A/D value. Move right twice
	bcf		STATUS,C
	rrf		TEMP,f
	rrf		A_D_LS,f
	bcf		STATUS,C
	rrf		TEMP,f
	rrf		A_D_LS,w		; 8bit value
	movwf	RAMP			; output change rate
; divide by 2 for 0-127 steps
	bcf		STATUS,C
	rrf		RAMP,f
	movlw	D'25'			; check if less than 25, set ramp at 0 so slow rate starts at about 1V
	subwf	RAMP,w
	btfss	STATUS,C
	clrf		RAMP
	movf	RAMP,w
	btfsc	STATUS,Z		; if zero bypass further check
	goto	CHECK_S1
; check if 51 or less
	movf	RAMP,w
	sublw	D'51'
	movlw	D'1'
	btfsc	STATUS,C		; >51 if carry is clear
	movwf	RAMP			; set at 1 for RAMP value between 25 and 51( allows a 1V range from 1-2V for initial slow ramp rate)	


CHECK_S1
; check if S1 closed or open
	btfsc	GPIO,1			; if high run normal mode 
	goto	START_RUN
; recheck after delay 
	call		DELAY100		;  100ms	
	btfsc	GPIO,1			; if high run normal mode
	goto	START_RUN
; recheck after delay
	call		DELAY100		;  100ms	
	btfsc	GPIO,1			; if low run the program mode
	goto	START_RUN
	
PROGRAM_MODE
; PROGRAM mode where input is read and stored against AN0 from program pot. Counter increased (counting from 1-16 parts to output curve
; clear VOLT value
	clrf		VOLT_VAL		; counts from 0 up to 15. Counts up each time S1 pressed to record code
; clear ramp rate
	clrf		RAMP			; rate at which output changes

; clear all stored codes to FF
; clear RAM
	movlw	H'30'
	movwf	FSR			; indirect pointer address
LOAD_FF
	movlw	H'FF'			; set at maximum value
	movwf	INDF			; clear memory
; stop when FSR=6F
	movf	FSR,w
	sublw	H'6E'
	btfss	STATUS,C		; when carry is clear then end of memory to read
	goto	WRITE_CLR
	incf		FSR,f			; write to RAM on ls bytes only (ms byte of 14-bit data ignored) 
	goto	LOAD_FF

WRITE_CLR
; clear flash in two 16byte steps
; first 16 bytes H0700-H070F
	movlw	H'07'
	movwf	READADDMS	 ; MS Byte of Program Address to write
	movlw	H'00'	
	movwf	READADDLS 	; LS Byte of Program Address to write
	movlw	H'30'			; ram start
	movwf	DATA_ADD		; Load initial data address
	call		WRITE			; write to flash memory
; second 16 bytes H0710-H071F
	movlw	H'07'
	movwf	READADDMS	 ; MS Byte of Program Address to write
	movlw	H'10'	
	movwf	READADDLS 	; LS Byte of Program Address to write
	movlw	H'50'			; ram start
	movwf	DATA_ADD		; Load initial data address
	call		WRITE			; write to flash memory

; wait for S1 open 
S1_OPEN;?
	call		DELAY100		;  100ms	
	btfss	GPIO,1			; if high continue with program mode
	goto	S1_OPEN
; flash LED for voltage value (1-16 times) VOLT_VAL counts up from 0 to 15
	movf	VOLT_VAL,w	; 	
	movwf	TEMP			; working value
F1	bsf		GPIO,5			; LED on
	call		DELAY100		;  100ms	
	call		DELAY100		;  100ms	
	call		DELAY100		;  100ms	
	bcf		GPIO,5			; LED off
	call		DELAY100		;  100ms	
	call		DELAY100		;  100ms	
	call		DELAY100		;  100ms	
	bsf		GPIO,5			; LED on
	movf	TEMP,w
	btfsc	STATUS,Z		; when zero end flash sequence 
	goto	END_FLSH
	decf	TEMP,f
	goto	F1

END_FLSH

; load PWM with program voltage value
; get program value from VR1, voltage measured at TP2
; bits 4-2
; 000 = Channel 0 (AN0)
	movlw	B'10000000'		; channel 0, right justified, VDD ref etc
	movwf	ADCON0
PRGM_IN

	bsf		ADCON0,0		; A/D on
; delay	
	call		DELAY100		;  100ms	
	
	call		ACQUIRE_AD	; read input
; ADRESH has MS bits (Bits1,0), A_D_LS has ls byte

; wait for new PWM update
	bcf		PIR1,TMR2IF
WAIT_NEW
	btfss	PIR1,TMR2IF
	goto	WAIT_NEW

	movlw	B'00001100'		; set PWM mode
	movwf	CCP1CON		; enable PWM operation
; place in PWM
; do ls bytes
	btfsc	A_D_LS,0		; if set then set bit 4 in CCP1CON 	
	bsf		CCP1CON,4
	btfsc	A_D_LS,1		; if set then set bit 5 in CCP1CON 	
	bsf		CCP1CON,5
; shift ADRESH and A_D_LS right two times for ms byte to PWM
	movf	ADRESH,w		; read only register
	movwf	SHIFT
	bcf		STATUS,C
	rrf		SHIFT,f
	rrf		A_D_LS,f
	bcf		STATUS,C
	rrf		SHIFT,f
	rrf		A_D_LS,w
	movwf	CCPR1L		; PWM loaded

; wait for S1 to close
	call		DELAY100		;  100ms	
	btfsc	GPIO,1
	goto	PRGM_IN		; switch not closed so read program voltage

; get input value
; bits 4-2
; 011 = Channel 03 (AN3)
	movlw	B'10001100'		; channel 3, right justified, VDD ref etc
	movwf	ADCON0
	bsf		ADCON0,0		; A/D on
; delay	
	call		DELAY100		;  100ms	
	call		ACQUIRE_AD	; read input
	
; load RAM address for input voltage
; multiply VOLT_VAL by 4 (as each voltage storage is 4 apart)
	movf	VOLT_VAL,w		; 
	movwf	TEMP
	bcf		STATUS,C
	rlf		TEMP,f
	bcf		STATUS,C
	rlf		TEMP,w
	addlw	H'30'			; voltage 1 location plus 4 x VOLT_VAL for location.
	movwf	FSR			; pointer to address
	movf	ADRESH,w		; input value
	movwf	INDF			; place in memory 
	incf		FSR,f
; bank 1
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w
	bcf		STATUS,RP0	; select memory bank 0	
	movwf	INDF	
 
; get program value for voltage
; bits 4-2
; 000 = Channel 0 (AN0)
	movlw	B'10000000'		; channel 0, right justified, VDD ref etc
	movwf	ADCON0
	bsf		ADCON0,0		; A/D on
; delay	
	call		DELAY100		;  100ms	
	call		ACQUIRE_AD	; read  input

	incf		FSR,f
	movf	ADRESH,w		; input value
	movwf	INDF			; place in memory 
	incf		FSR,f
; bank 1
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w
	bcf		STATUS,RP0	; select memory bank 0	
	movwf	INDF	

WRTE_FLSH
; write to flash in two 16byte steps
; first 16 bytes H0700-H070F
	movlw	H'07'
	movwf	READADDMS	 ; MS Byte of Program Address to write
	movlw	H'00'	
	movwf	READADDLS 	; LS Byte of Program Address to write
	movlw	H'30'			; ram start
	movwf	DATA_ADD		; Load initial data address
	call		WRITE			; write to flash memory
; second 16 bytes H0710-H071F
	movlw	H'07'
	movwf	READADDMS	 ; MS Byte of Program Address to write
	movlw	H'10'	
	movwf	READADDLS 	; LS Byte of Program Address to write
	movlw	H'50'			; ram start
	movwf	DATA_ADD		; Load initial data address
	call		WRITE	

; wait for S1 open
S1_O
	call		DELAY100		;  100ms	
	btfss	GPIO,1
	goto	S1_O

; LED1 out when stored
	bcf		GPIO,5

; VOLT_VAL increased; stops at end of 15
	incf		VOLT_VAL,f
	movf	VOLT_VAL,w
	sublw	D'15'			; if over 15 end of programming. 
	btfsc	STATUS,C	
	goto	S1_OPEN		; next switch

PROG_END
	goto	PROG_END 		; loop until powered off	

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
START_RUN ; normal running
; set up input read value
; bits 4-2
; 011 = Channel 03 (AN3)
	movlw	B'10001100'		; channel 3, right justified, VDD ref etc
	movwf	ADCON0
	bsf		ADCON0,0		; A/D on
; delay	
	call		DELAY100		;  100ms	

RUN;  loop from here. Checks switch first

;..............................................................................................................
; ramp rate for output set when S1 pressed. VR1 at AN0 sets rate
; check if S1 pressed
; check if S1 closed or open
	btfsc	GPIO,1			; if high run normal mode 
	goto	RUN1
; recheck after delay 
	call		DELAY100		;  100ms	
	btfsc	GPIO,1			; if high run normal mode
	goto	RUN1
; recheck after delay
	call		DELAY100		;  100ms	
	btfsc	GPIO,1			; if low set the ramp rate
	goto	RUN1

; LED on
	bsf		GPIO,5
	
; set ramp rate
; bits 4-2
; 000 = Channel 00 (AN0)
	movlw	B'10000000'		; channel 0, right justified, VDD ref etc
	movwf	ADCON0
	bsf		ADCON0,0		; A/D on
; delay	
	call		DELAY100		;  100ms	
	call		ACQUIRE_AD	; read input
; ADRESH has MS bits (Bits1,0), A_D_LS has ls byte

	movf	ADRESH,w
	movwf	TEMP			; get ADRESH into working register
; set for 8-bits A/D value. Move right twice
	bcf		STATUS,C
	rrf		TEMP,f
	rrf		A_D_LS,f
	bcf		STATUS,C
	rrf		TEMP,f
	rrf		A_D_LS,w		; 8bit value
	movwf	RAMP			; output change rate
; divide by 2 for 0-127 steps
	bcf		STATUS,C
	rrf		RAMP,f
	movlw	D'25'			; check if less than 25, set ramp at 0 so slow rate starts at about 1V
	subwf	RAMP,w
	btfss	STATUS,C
	clrf		RAMP
	movf	RAMP,w
	btfsc	STATUS,Z		; if zero bypass further check
	goto	WAIT_1
; check if 51 or less
	movf	RAMP,w
	sublw	D'51'
	movlw	D'1'
	btfsc	STATUS,C		; >51 if carry is clear
	movwf	RAMP			; set at 1 for RAMP value between 25 and 51( allows a 1V range from 1-2V for initial slow ramp rate)	

; wait for switch open
WAIT_1
	btfss	GPIO,1			; if low,  wait
	goto	WAIT_1	
; LED off
	bcf		GPIO,5
	goto	START_RUN		;  A/D set for input
;........................................................................................................................

RUN1
; read input. 
	call		ACQUIRE_AD	; read input
; input value is in ADRESH, ms bytes and A_D_LS, ls byte

; Find band of operation and position in band
; work out required output using band position for programmed output values

; input bands 
; start at top band
; IN1ms, IN1ls to IN2ms, IN2ls
; IN1 set to maximum input value
; set FSR
	movlw	H'34'			; IN2ms position 	
	movwf	FSR			; initial position for FSR
BAND_LOOP

; get band high byte
	movf	INDF,w
	movwf	STORE1

	movf   	ADRESH,w 	 	; input value high byte 
    	subwf   	INDF,w		  	; subtract band  high byte
	movwf	TEMP			; keep subtraction value
	incf		FSR,f			; next is low byte

; get band low byte
	movf	INDF,w
	movwf	STORE2

	movf	A_D_LS,w		; low bytes
	subwf	INDF,w
	btfss	STATUS,C
	decf	TEMP,f			; decrease if carry
; test for end of bands
	movf	FSR,w
	sublw	H'6D'
	btfsc	STATUS,C
	goto	TEST_LOWER
; check if last value (H'6C') is 3F for the ms byte ie unprogrammed
	movf	IN16ms,w		; at H6C
	xorlw	H'3F'
	btfss	STATUS,Z
	goto	CALCULATE		; end of bands FSR at INxls
; set output at 00
	clrf		OUT0
	clrf		OUT1
	call		LOAD_OUTPUT
	goto	RUN	
	
TEST_LOWER
; test for within lower value in band
	btfsc	TEMP,7			; if set then input larger value than bottom of band
	goto	CALCULATE
; check if equal to lower value in band
; compare high byte STORE1 against ADRESH, and low bytes STORE2 against A_D_LS
	movf	ADRESH,w
	xorwf	STORE1,w
	btfss	STATUS,Z
	goto	NXT_BAND
	movf	A_D_LS,w
	xorwf	STORE2,w
	btfsc	STATUS,Z
	goto	CALCULATE
NXT_BAND; not in last band, check next band
	movlw	D'3'
	addwf	FSR,f			; skip CURVExms and CURVExls to next INxms location 
	goto	BAND_LOOP
	
CALCULATE
; get span  and bottom span values for input and output

; Input span (INxms INxls - INx+1ms INx+1ls)
; FSR currently at INx+1ls
	decf	FSR,f
	movf	INDF,w			; INx+1ms
	movwf	IN_BAND0		; store INX+1ms
	movlw	D'4'
	subwf	FSR,f			; back to previous
	movf	IN_BAND0,w		; recall 
	subwf	INDF,w			; INxms
	movwf	BAND_SPAN0	; ms byte store
; forward to INx+1ls
	movlw	D'5'
	addwf	FSR,f
	movf	INDF,w			; INx+1ls	
	movwf	IN_BAND1		; store 
	movlw	D'4'
	subwf	FSR,f			; back to previous	
	movf	IN_BAND1,w		; recall 
	subwf	INDF,w			; INxls	
	movwf	BAND_SPAN1
	btfss	STATUS,C
	decf	BAND_SPAN0,f

;  Output span (CURVExms CURVExls - CURVEx+1ms CURVEx+1ls)

; position FSR currently at INxls
	movlw	D'5'				; forward to CURVEx+1ms
	addwf	FSR,f
	movf	INDF,w			; CURVEx+1ms
	movwf	OUT_BAND0		; store
	movlw	D'4'				; back to CURVExms
	subwf	FSR,f
	movf	OUT_BAND0,w	; recall 
	subwf	INDF,w			; CURVExms
	movwf	OUT_SPAN0		; ms byte store
	movlw	D'5'				; forward to CURVEx+1ls
	addwf	FSR,f
	movf	INDF,w			; CURVEx+1ls
	movwf	OUT_BAND1		; store
	movlw	D'4'				; back to CURVExls
	subwf	FSR,f	
	movf	OUT_BAND1,w	; recall 
	subwf	INDF,w			; CURVExls
	movwf	OUT_SPAN1
	btfss	STATUS,C
	decf	OUT_SPAN0,f	; ms byte reduced

; test for negative
	clrf		NEGATIVE
	btfss	OUT_SPAN0,7 	; negative if set
	goto	TEST_AGAIN
	bsf		NEGATIVE,0		; set negative flag

; Negative, so reverse subtraction
; Output span (CURVEx+1ms CURVEx+1ls - CURVExms CURVExls

; position FSR currently at CURVExls

	decf	FSR,f			; CURVExls to CURVExms
	movf	INDF,w			; CURVExms
	movwf	TEMP			; store
	movlw	D'4'				; forward to CURVEx+1ms
	addwf	FSR,f
	movf	INDF,w
	movwf	OUT_BAND0		; get CURVEx+1ms
	movf	TEMP,w			; recall 
	subwf	INDF,w			; CURVEx+1ms
	movwf	OUT_SPAN0	
	movlw	D'3'				; back to CURVExls
	subwf	FSR,f
	movf	INDF,w			; CURVExls
	movwf	TEMP			; store 
	movlw	D'4'				; forward to CURVEx+1ls
	addwf	FSR,f
	movf	INDF,w
	movwf	OUT_BAND1		; 	
	movf	TEMP,w			; recall 
	subwf	INDF,w			; CURVEx+1ls
	movwf	OUT_SPAN1	
	btfss	STATUS,C
	decf	OUT_SPAN0,f	; ms byte reduced

TEST_AGAIN; successive approximation interpolation loop 
; compare measured input against  IN_BAND0,1 + (BAND_SPAN0,1) /2 , then /4, /8, /16 etc 	
; measured value of voltage ADRESH  ms byte,  A_D_LS is  ls byte

; divide input band span by 2
	bcf		STATUS,C
	rrf		BAND_SPAN0,f
	rrf		BAND_SPAN1,f
; also divide output span by 2
; divide out span by 2 
	bcf		STATUS,C
	rrf		OUT_SPAN0,f
	rrf		OUT_SPAN1,f

; end when values are 0
	movf	BAND_SPAN0,w
	btfss	STATUS,Z
	goto	INTERPOLATION_GO
	movf	BAND_SPAN1,w
	btfsc	STATUS,Z
	goto	INTERPOLATION_END

INTERPOLATION_GO
; add to IN_BAND
	movf	IN_BAND0,w
	addwf	BAND_SPAN0,w
	movwf	STORE1
	movf	IN_BAND1,w
	addwf	BAND_SPAN1,w
	movwf	STORE2	
	btfsc	STATUS,C		; if over increase ms byte
	incf		STORE1,f

; compare with measured input (STORE1, STORE2 - ADRESH, A_D_LS)
	movf	ADRESH,w
	subwf	STORE1,w
	movwf	TEMP
	movf	A_D_LS,w
	subwf	STORE2,w
	btfss	STATUS,C
	decf	TEMP,f			; reduce if ls byte is over
; if bit 7 is set then measure ADRESH, A_D_LS is greater)
	btfsc	TEMP,7
	goto	GREATER1
; if set then keep STORE1,2 and add OUT_BAND0,1 to (OUT_SPAN0,1)/2
; if  clear use IN_BAND0,1
	goto	TEST_AGAIN
	
GREATER1
; keep STORE1,2	(transfer to IN_BAND0,1)
	movf	STORE1,w
	movwf	IN_BAND0
	movf	STORE2,w
	movwf	IN_BAND1

; addition of  OUT_BAND0,1 to (OUT_SPAN0,1)/2 or /4 or /8 etc

; check negative flag
	btfss	NEGATIVE,0
	goto	ADD_OUT_SPAN
; subtract
	movf	OUT_SPAN0,w
	subwf	OUT_BAND0,f
	movf	OUT_SPAN1,w
	subwf	OUT_BAND1,f
	btfss	STATUS,C		; if over, decrease ms byte
	decf	OUT_BAND0,f
; test again
	goto	TEST_AGAIN

ADD_OUT_SPAN 
; add
	movf	OUT_SPAN0,w
	addwf	OUT_BAND0,f
	movf	OUT_SPAN1,w
	addwf	OUT_BAND1,f
	btfsc	STATUS,C		; if over increase ms byte
	incf		OUT_BAND0,f
; test again
	goto	TEST_AGAIN
	
INTERPOLATION_END; 
	movf	OUT_BAND0,w
	movwf	OUT0
	movf	OUT_BAND1,w
	movwf	OUT1
	call		LOAD_OUTPUT
	goto	RUN

;.......................................................................................................................................

LOAD_OUTPUT ; loads PWM output

; if OUT0,1_RAMP=OUT0,1 then no change 
	movf	OUT0_RAMP,w	; current ms byte
	subwf	OUT0,w			; required ms byte
	btfss	STATUS,Z
	goto	CHANGE
	movf	OUT1_RAMP,w	; current ls byte
	subwf	OUT1,w			; required ls byte
	btfsc	STATUS,Z
	return					; no change required

CHANGE
	movf	RAMP,w
	btfss	STATUS,Z		; if ramp rate is zero, fastest ramp so directly transfer values
	goto	RAMP_U_D
	movf	OUT0,w			; required value ms byte
	movwf	OUT0_RAMP	; ramping value ms byte
	movf	OUT1,w			; required value ls byte
	movwf	OUT1_RAMP	; ramping value ls byte
	goto	PLACE

RAMP_U_D
; compare 
	movf	OUT0_RAMP,w	; current ms byte
	subwf	OUT0,w			; required ms byte
	movwf	TEMP
	movf	OUT1_RAMP,w	; current ls byte
	subwf	OUT1,w
	btfss	STATUS,C
	decf	TEMP,f			; increase if carry
; if OUT0,1_RAMP>OUT0,1 then decrease 
	btfss	TEMP,7			; if set then OUT0,1_RAMP>OUT0,1
	goto	INC_OUT

; decrease OUT0,1_RAMP
DEC_OUT
	movlw	D'1'
	subwf	OUT1_RAMP,f	; low byte
	btfss	STATUS,C
	decf	OUT0_RAMP,f	; decrease high byte if low byte overranges
; ramp value sets delay
	movf	RAMP,w
	call		DY				; delay
	call		PLACE

; check ramp value
RAMP_DEC
	movf	RAMP_COUNT,w
	btfss	STATUS,Z
	goto	RAMP_LOOP_DEC
	movf	RAMP,w			; output change rate
	movwf	RAMP_COUNT	; to working counter
	goto	CF_DEC
RAMP_LOOP_DEC
	decf	RAMP_COUNT,f
	goto	RAMP_DEC	

CF_DEC
	call		CK_ZERO
; check when OUT0,1_RAMP = OUT0,1
; if OUT0,1_RAMP=OUT0,1 then end change 
;	if w is zero then =
	xorlw	D'00'
	btfss	STATUS,Z
	goto	DEC_OUT
	goto	PLACE

INC_OUT; increase out ramp.

; if OUT0,1_RAMP<OUT0,1 then increase
	movlw	D'1'
	addwf	OUT1_RAMP,f	; low byte
	btfsc	STATUS,C
	incf		OUT0_RAMP,f	; increase high byte if low byte overranges
; ramp value sets delay
	movf	RAMP,w
	call		DY				; delay
	call		PLACE

; check ramp value
RAMP_INC
	movf	RAMP_COUNT,w
	btfss	STATUS,Z
	goto	RAMP_LOOP_INC
	movf	RAMP,w			; output change rate
	movwf	RAMP_COUNT	; to working counter
	goto	CF_INC
RAMP_LOOP_INC
	decf	RAMP_COUNT,f
	goto	RAMP_INC	

CF_INC
	call		CK_ZERO
; check when OUT0,1_RAMP = OUT0,1
; if OUT0,1_RAMP=OUT0,1 then end change 
;	if w is zero then =
	xorlw	D'00'
	btfss	STATUS,Z
	goto	INC_OUT
;	goto	PLACE
	
PLACE	
; wait for new PWM loading
	bcf		PIR1,TMR2IF
WAIT_NEW_RUN
	btfss	PIR1,TMR2IF
	goto	WAIT_NEW_RUN
; place in PWM
; changes required
	movlw	B'00001100'		; clear bits 4 and 5
	movwf	CCP1CON		; PWM operation
; do ls bytes
	btfsc	OUT1_RAMP,0		; if set then set bit 4 in CCP1CON 	
	bsf		CCP1CON,4
	btfsc	OUT1_RAMP,1		; if set then set bit 5 in CCP1CON 	
	bsf		CCP1CON,5
; shift OUT0_RAMP and OUT1_RAMP right two times for ms byte to PWM
; place OUT0,1_RAMP to working registers so OUT0,1_RAMP does not change
	movf	OUT0_RAMP,w
	movwf	STORE1
	movf	OUT1_RAMP,w
	movwf	STORE2

	bcf		STATUS,C
	rrf		STORE1,f
	rrf		STORE2,f
	bcf		STATUS,C
	rrf		STORE1,f
	rrf		STORE2,w
	movwf	CCPR1L		; PWM loaded
	return

CK_ZERO
; check when OUT0,1_RAMP = OUT0,1
; if OUT0,1_RAMP=OUT0,1 then end change 
	movf	OUT0_RAMP,w	; current ms byte
	subwf	OUT0,w			; required ms byte
	btfss	STATUS,Z
	retlw	D'55'			; not zero
	movf	OUT1_RAMP,w	; current ls byte
	subwf	OUT1,w			; required ls byte
	btfsc	STATUS,Z
	retlw	D'00'			; zero		
	retlw	D'55'			; not zero

; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,1	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,1	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
; bank 1
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w
	bcf		STATUS,RP0	; select memory bank 0
	movwf	A_D_LS			; ls byte
	return
;.................................................

; delay loop 
DY	movwf	STORE1		; STORE1 is number of loops value
LOOP8
	decfsz	STORE1,f
	goto	LOOP8
	return

; delay loop 
DELAY100 ; approx 100ms
	movlw	D'255'		; delay value
	movwf	STORE1		; STORE1 is number of loops value
LOOP800	
	movlw	D'213'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP900
	decfsz	STORE2,f
	goto	LOOP900
	decfsz	STORE1,f
	goto	LOOP800
	return
;........................................

; read data memory
READ; 'w' has read data
	bsf		STATUS,RP0	; select memory bank 1 
	movf	READADDMS,w 
	movwf 	PMADRH		; ms Byte of Program Address to read
	movf	READADDLS,w
	movwf 	PMADRL 		; ls Byte of Program Address to read

	bsf	 	PMCON1,RD 	; Read
	nop 					
	nop
; memory is read in second cycle PM read instruction
	movf	PMDATH,w 		; ms Byte of Program data 
	movwf	TEMP_VAL
	movf	PMDATL,w 		; ls Byte of Program data
	bcf		STATUS,RP0	; bank 0
	return
;.............................................

; write to data memory
WRITE
	bcf		 INTCON,GIE 	; Disable interrupts 
G	btfsc	 INTCON,GIE		 ; See AN576
	goto	 G

	bsf		STATUS,RP0	; select memory bank 1
	movf	READADDMS,w 
	movwf 	PMADRH		; MS Byte of Program Address to write
	movf	READADDLS,w 
	movwf 	PMADRL 		; LS Byte of Program Address to write

	movf	DATA_ADD,w	; Load initial data address (must start at a 16byte boundary) 
	movwf	FSR 
LOOP_WRITE 
	movf	 INDF,w 			; Load first data byte into upper byte
	movwf	 PMDATH		;
	incf		 FSR,f 			; Next byte
	movf	 INDF,w 			; Load second data byte into lower byte
	movwf	 PMDATL 		; 		
	incf		 FSR,f 			;
	bsf		 PMCON1,WREN ; Enable writes

; Required Sequence
	movlw	H'55'			; Start of required write sequence:
	movwf	PMCON2		; Write 55h
	movlw	H'AA'		 	;
	movwf	PMCON2 		; Write AAh
	bsf		PMCON1,WR 	; Set WR bit to begin write
	nop					 	; NOPs required for time to transfer data to the buffer registers
	nop						; 
;
	bcf		PMCON1,WREN ; Disable writes
	movf	PMADRL,w
	incf		PMADRL,f		; Increment address
; select 4,8,12 or16 	
	; 0F = 16 words
	; 0B = 12 words
	; 07 =  8 words
	; 03 =  4 words
	andlw	H'0F'			; Indicates when the set number of words have been programmed
	sublw	H'0F'

	btfss	STATUS,Z 		; Exit on a match,
	goto	LOOP_WRITE	; Continue until ended
	bcf		STATUS,RP0	; bank 0
	bsf		 INTCON,GIE 	; enable interrupts 
	return


	end